<?php

namespace Smartwave\PortoChild\Block\Product\View;

use Magento\Catalog\Api\ProductRepositoryInterface;
use Magento\Framework\Pricing\PriceCurrencyInterface;

class Attributes extends  \Magento\Catalog\Block\Product\View\Attributes
{
    protected $_productRepo;
    protected $_filterHelper;

    public function __construct(
        \Magento\Framework\View\Element\Template\Context $context,
        \Magento\Framework\Registry $registry,
        PriceCurrencyInterface $priceCurrency,
        ProductRepositoryInterface $productRepository,
        \Amasty\Shopby\Helper\FilterSetting $filterHelper,
        array $data = []
    )
    {
        $this->_productRepo = $productRepository;
        $this->_filterHelper = $filterHelper;

        parent::__construct($context, $registry, $priceCurrency, $data);
    }

    public function setProductById($productId)
    {
        $this->_product = $this->_productRepo->getById($productId);

        return $this;
    }

    public function filterPriceValue($code, $value)
    {
        $value = $this->priceCurrency->convertAndFormat($value);
        $setting = $this->_filterHelper->getSettingByAttributeCode($code);
        if (!$setting->getUnitsLabelUseCurrencySymbol()) {
            $value = preg_replace('@<[^>]+>@u', '', $value);
            $pattern = '@\s*' . preg_quote($this->priceCurrency->getCurrencySymbol(), '@') . '\s*@u';
            $value = preg_replace($pattern, '', $value);
            $value .= ' ' . $setting->getUnitsLabel();
        }

        return $value;
    }
}