<?php
/**
 * @category Mageants FastOrder
 * @package Mageants_FastOrder
 * @copyright Copyright (c) 2018 Mageants
 * @author Mageants Team <support@mageants.com>
 */

namespace Smartwave\PortoChild\Helper;

class Warehouse extends \Magento\Framework\App\Helper\AbstractHelper
{
	protected $_source_items_api;
	protected $_source_api;
	protected $_log;

	private $_sources = null;

    /**
     * @param \Magento\Framework\App\Helper\Context   $context
     * @param \Magento\Backend\Model\UrlInterface $backendUrl
     * @param \Magento\Store\Model\StoreManagerInterface $storeManager
     */
    public function __construct(
		\Magento\Framework\App\Helper\Context $context,
		\Magento\InventoryApi\Api\GetSourceItemsBySkuInterface $source_items_api,
        \Magento\InventoryApi\Api\SourceRepositoryInterface $source_api,
		\Psr\Log\LoggerInterface $logger
    ) {
        $this->_source_items_api = $source_items_api;
		$this->_source_api = $source_api;
		$this->_logger = $logger;

        parent::__construct($context);
    }
	
	public function getInventoriesBySource($sku)
	{
		$sources = $this->_source_items_api->execute($sku);
		$inventories = array();
		foreach ($sources as $sourceItem) {
			$sourceInfo = $this->_source_api->get( $sourceItem->getSourceCode() );
			if (empty($sourceInfo)) {
				// $this->_logger->critical( 'empty' );
			} else {
				$inventories[] = array(
					'code' => $sourceInfo->getSourceCode(),
					'source' => $sourceInfo->getName(),
					'qty' => $sourceItem->getQuantity(),
				);
			}
        }
        
		return $inventories;
	}
	
	public function getInventorySourceList()
	{
		if (!empty($this->_sources)) {
			return $this->_sources;
		}

		$objectManager = \Magento\Framework\App\ObjectManager::getInstance();
		$sourceList = $objectManager->get('\Magento\Inventory\Model\ResourceModel\Source\Collection');
		$sourceListArr = $sourceList->load();
		$i=1;
		
		$sourceAllList[0] = array('label'=>'', 'value'=>'');
		$sourceList = array();
		foreach ($sourceListArr as $sourceItemName) {
			$sourceCode = $sourceItemName->getSourceCode();
			$sourceName = $sourceItemName->getName();
		
			$sourceList['value'] = $sourceCode;
			$sourceList['label'] = $sourceName;
		
			$sourceAllList[$sourceCode] = $sourceList;
		
			$i++;
		}
		
		$this->_sources = $sourceAllList;
		return $this->_sources;
	}

	public function getInventorySourceLabel($code) {
		if (empty($this->_sources)) {
			$this->getInventorySourceList();
		}
		return empty($this->_sources[$code]) ? '' : $this->_sources[$code]['label'];
	}

}
